/*
 * Decompiled with CFR 0.152.
 */
package com.redpxnda.respawnobelisks.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.redpxnda.respawnobelisks.config.RespawnObelisksConfig;
import com.redpxnda.respawnobelisks.registry.block.RespawnObeliskBlock;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={PlayerList.class})
public abstract class PlayerListMixin {
    @WrapOperation(method={"respawn"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerPlayer;moveTo(DDDFF)V")})
    private void RESPAWNOBELISKS_moveToMixin(ServerPlayer instance, double x, double y, double z, float yRot, float xRot, Operation<Void> original, ServerPlayer pPlayer) {
        BlockState blockstate;
        BlockPos blockpos = pPlayer.m_8961_();
        if (blockpos != null && (blockstate = pPlayer.m_9236_().m_8055_(blockpos)).m_60734_() instanceof RespawnObeliskBlock) {
            if (blockstate.m_61143_((Property)RespawnObeliskBlock.RESPAWN_SIDE) == Direction.NORTH) {
                yRot = 180.0f;
            } else if (blockstate.m_61143_((Property)RespawnObeliskBlock.RESPAWN_SIDE) == Direction.EAST) {
                yRot = -90.0f;
            } else if (blockstate.m_61143_((Property)RespawnObeliskBlock.RESPAWN_SIDE) == Direction.SOUTH) {
                yRot = 0.0f;
            } else if (blockstate.m_61143_((Property)RespawnObeliskBlock.RESPAWN_SIDE) == Direction.WEST) {
                yRot = 90.0f;
            }
        }
        instance.m_7678_(x, y, z, yRot, xRot);
    }

    @WrapOperation(method={"respawn"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;findRespawnPositionAndUseSpawnBlock(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/BlockPos;FZZ)Ljava/util/Optional;")})
    private Optional<Vec3> findRespawnPositionAndUseSpawnBlock(ServerLevel pServerLevel, BlockPos pSpawnBlockPos, float pPlayerOrientation, boolean pIsRespawnForced, boolean pRespawnAfterWinningTheGame, Operation<Optional<Vec3>> original, ServerPlayer pPlayer) {
        Optional<Vec3> optional;
        BlockState blockState = pServerLevel.m_8055_(pSpawnBlockPos);
        if (RespawnObelisksConfig.isBlockBanned(blockState)) {
            return Optional.empty();
        }
        Block block = blockState.m_60734_();
        if (block instanceof RespawnObeliskBlock) {
            RespawnObeliskBlock block2 = (RespawnObeliskBlock)block;
            optional = block2.getRespawnLocation(blockState, pSpawnBlockPos, pServerLevel, pPlayer);
        } else {
            optional = Player.m_36130_((ServerLevel)pServerLevel, (BlockPos)pSpawnBlockPos, (float)pPlayerOrientation, (boolean)pIsRespawnForced, (boolean)pRespawnAfterWinningTheGame);
        }
        return optional;
    }
}

